// ### INCLUDES #############################################################
#include <dos.h>
#include <stdio.h>
#include <alloc.h>
#include "sbcommon.h"

// ### VARIABLES ############################################################
unsigned long DMAbufsize;

// ### ROUTINES #############################################################
void far *DMAbufptr,*DMAbufptr2;
unsigned long DMAbufadr,DMAbufadr2;
static DMAch;

// ### GETBUF ###############################################################
static int GetBuf(void far **ptr,unsigned long *adr)
{
        unsigned long tries[16],t;
        int i;
        for(i=0;i<16;i++) {
                tries[i]=(unsigned long)farmalloc(DMAbufsize+15);
                if(tries[i]==NULL)
                return 1;
                t=tries[i]&0xFFFF;
                t+=(tries[i]>>12)&0xFFFF0L;
                if((t>>16)==((t+DMAbufsize)>>16))
                break;
                }
        if(i==16)
        return 1;
        *ptr=(void *)tries[i];
        *adr=t;
        for(i-=1;i>=0;i--) {
                farfree((void *)tries[i]);
                }
        return 0;
        }

// ### DMAAUTOINIT ##########################################################
int DMAAutoInit(int ch, unsigned long bufsize)
{
        unsigned char page;
        unsigned short offset;
        unsigned short length;
        unsigned short iop,ioa,iol,msk,mod,clr;
        DMAbufsize=bufsize;
        if(GetBuf(&DMAbufptr,&DMAbufadr))
        return 1;
        if(ch>3)
        {
                page=(DMAbufadr>>16)&0xE;
                length=(DMAbufsize>>1)-1;
                offset=(DMAbufadr>>1)&0xFFFF;
                }
        else
        {
                page=(DMAbufadr>>16)&0xF;
                length=DMAbufsize-1;
                offset=DMAbufadr&0xFFFF;
                }
        switch(ch)
        {
                case 0: iop=0x87;
                ioa=0x00;
                iol=0x01;
                msk=0x0A;
                mod=0x0B;
                clr=0x0C;
                break;
                case 1: iop=0x83;
                ioa=0x02;
                iol=0x03;
                msk=0x0A;
                mod=0x0B;
                clr=0x0C;
                break;
                case 2: iop=0x81;
                ioa=0x04;
                iol=0x05;
                msk=0x0A;
                mod=0x0B;
                clr=0x0C;
                break;
                case 3: iop=0x82;
                ioa=0x06;
                iol=0x07;
                msk=0x0A;
                mod=0x0B;
                clr=0x0C;
                break;
                case 4: iop=0x8F;
                ioa=0xC0;
                iol=0xC2;
                msk=0xD4;
                mod=0xD6;
                clr=0xD8;
                break;
                case 5: iop=0x8B;
                ioa=0xC4;
                iol=0xC6;
                msk=0xD4;
                mod=0xD6;
                clr=0xD8;
                break;
                case 6: iop=0x89;
                ioa=0xC8;
                iol=0xCA;
                msk=0xD4;
                mod=0xD6;
                clr=0xD8;
                break;
                case 7: iop=0x8A;
                ioa=0xCC;
                iol=0xCE;
                msk=0xD4;
                mod=0xD6;
                clr=0xD8;
                break;
                default:Cleanup ("Unsupported DMA");
                return(1);
                }
        outportb(msk,ch|4);
        //Een regel naar voor verplaatst [Moved one line forward]
        outportb(clr,0);
        outportb(mod,(ch&3)|0x58);
        outportb(ioa,offset&255);
        outportb(ioa,offset>>8);
        outportb(iop,page);
        //Niet nodig [Unnessecary]
        //outportb(clr,0);
        outportb(iol,length&255);
        outportb(iol,length>>8);
        outportb(msk,ch&3);
        return(0);
        }

// ### DMASINGLEGO ##########################################################
void DMASingleGo(int which)
{
        unsigned char page;
        unsigned short offset;
        unsigned short length;
        unsigned short iop,ioa,iol,msk,mod,clr;
        if(DMAch>3)
        {
                page=(which?DMAbufadr2:DMAbufadr)>>16&0xE;
                length=(DMAbufsize>>1)-1;
                offset=((which?DMAbufadr2:DMAbufadr)>>1)&0xFFFF;
                }
        else
        {
                page=(which?DMAbufadr2:DMAbufadr)>>16&0xF;
                length=DMAbufsize-1;
                offset=(which?DMAbufadr2:DMAbufadr)&0xFFFF;
                }
        switch(DMAch)
        {
                case 0: iop=0x87;
                ioa=0x00;
                iol=0x01;
                msk=0x0A;
                mod=0x0B;
                clr=0x0C;
                break;
                case 1: iop=0x83;
                ioa=0x02;
                iol=0x03;
                msk=0x0A;
                mod=0x0B;
                clr=0x0C;
                break;
                case 2: iop=0x81;
                ioa=0x04;
                iol=0x05;
                msk=0x0A;
                mod=0x0B;
                clr=0x0C;
                break;
                case 3: iop=0x82;
                ioa=0x06;
                iol=0x07;
                msk=0x0A;
                mod=0x0B;
                clr=0x0C;
                break;
                case 4: iop=0x8F;
                ioa=0xC0;
                iol=0xC2;
                msk=0xD4;
                mod=0xD6;
                clr=0xD8;
                break;
                case 5: iop=0x8B;
                ioa=0xC4;
                iol=0xC6;
                msk=0xD4;
                mod=0xD6;
                clr=0xD8;
                break;
                case 6: iop=0x89;
                ioa=0xC8;
                iol=0xCA;
                msk=0xD4;
                mod=0xD6;
                clr=0xD8;
                break;
                case 7: iop=0x8A;
                ioa=0xCC;
                iol=0xCE;
                msk=0xD4;
                mod=0xD6;
                clr=0xD8;
                break;
                }
        outportb(msk,DMAch|4);
        //Een regel naar voor verplaatst [moved one line forward]
        outportb(clr,0);
        outportb(mod,(DMAch&3)|0x48);
        outportb(ioa,offset&255);
        outportb(ioa,offset>>8);
        outportb(iop,page);
        //Niet nodig [unnessecary]
        //outportb(clr,0);
        outportb(iol,length&255);
        outportb(iol,length>>8);
        outportb(msk,DMAch&3);
        }

// ### DMASINGLEINIT ########################################################
int DMASingleInit(int ch, unsigned long bufsize)
{
        DMAbufsize=bufsize;
        if(GetBuf(&DMAbufptr,&DMAbufadr)||GetBuf(&DMAbufptr2,&DMAbufadr2))
        return 1;
        DMAch=ch;
        return 0;
        }

