// ### INCLUDES #############################################################
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <mem.h>
#include <dos.h>
#include <alloc.h>
#include "sound.h"
#include "dma.h"

// ### DEFINES ##############################################################
#define DSPRESET 0x6
#define DSPREAD 0xA
#define DSPWRITE 0xC
#define DSPSTAT 0xE

// ### VARIABLES ############################################################
static int SBver,SBbase,SBint,SBdma8,SBdma16,SBcurdmahalf;
static void interrupt (*oldint)(void);
unsigned char *SBbuf;
int SBDataEnd;

// ### SBGETSETTINGS ########################################################
static int SBGetSettings(void)
{
        int i;
        char *BLASTER=getenv("BLASTER");
        if(BLASTER==NULL)
        if((BLASTER=getenv("blaster"))==NULL)
        {
                //                        Cleanup ("SET BLASTER not detected");
                return(1);
                }
        for(i=0;BLASTER[i]!=0;i++) {
                switch(BLASTER[i]) {
                        case 'A':SBbase=(BLASTER[i+1]-'0')*0x100+
                        (BLASTER[i+2]-'0')*0x10+
                        (BLASTER[i+3]-'0');
                        break;
                        case 'I':SBint=atoi(&BLASTER[i+1]);
                        break;
                        case 'D':SBdma8=atoi(&BLASTER[i+1]);
                        break;
                        case 'H':SBdma16=atoi(&BLASTER[i+1]);
                        break;
                        default: break;
                        }
                }
        return(0);
        }

// ### SBREADDSP ############################################################
static int SBReadDSP(void)
{
        while((inp(SBbase+DSPSTAT)&0x80)==0);
        return(inp(SBbase+DSPREAD));
        }

// ### SBWRITEDSP ###########################################################
static void SBWriteDSP(unsigned char data)
{
        while(inp(SBbase+DSPWRITE)&0x80);
        outportb(SBbase+DSPWRITE,data);
        }

// ### SBRESETDSP ###########################################################
static int SBResetDSP(void)
{
        unsigned int i;
        outportb(SBbase+DSPRESET,1);
        for(i=0;i<8;i++) {
                inportb(SBbase+DSPRESET);
                }
        outportb(SBbase+DSPRESET,0);
        for(i=0;i<65535;i++) {
                if(inp(SBbase+DSPSTAT)&0x80)
                {
                        if(inp(SBbase+DSPREAD)==0xAA)
                        break;
                        }
                }
        if(i==65535)
        {
                SBbase=0;
                SBint=0;
                SBdma8=0;
                SBdma16=0;
                return (1);
                }
        return(0);
        }

// ### SBGETVER #############################################################
static int SBGetVer(void)
{
        int maj;
        SBWriteDSP(0xE1);
        maj=SBReadDSP();
        SBReadDSP();
        // maj=1  SB 8 bit
        // maj=2  SB 2.0
        // maj=3  SB pro
        // maj=4  SB 16/AWE32/AWE64
        if (maj<4) maj=1;
        // just sb8 or sb16
        return(maj);
        }

// ### TIMECONSTANT #########################################################
long TimeConstant(long freq)
{
        return 256-(1000000/freq);
        }

// ### SB8CONVERT ###########################################################
static void SB8Convert(void)
{
        long int i;
        for(i=SNDmixlen-1;i>=0;i--) {
                SBbuf[i]=(SNDbuf[i]>>8)^0x80;
                }
        }

// ### SB8IRQHANDLER ########################################################
void interrupt SB8IRQHandler(void)
{
        // /*I THINK YOU _DO_ NEED THIS*/asm cli
        asm db 0x66
        asm push bx
        asm db 0x66
        asm push dx
        asm db 0x66
        asm push ax/*I THINK YOU _DO_ NEED THIS*/
        DMASingleGo(SBcurdmahalf);
        SBcurdmahalf=!SBcurdmahalf;
        SBWriteDSP(0x14);
        SBWriteDSP((SNDmixlen-1)&0xff);
        SBWriteDSP((SNDmixlen-1)>>8);
        SNDMix();
        SB8Convert();
        _fmemcpy(SBcurdmahalf?DMAbufptr2:DMAbufptr,SBbuf,SNDmixlen);
        inp(SBbase+0xE);
        outportb( 0x20,0x20);
        /*I THINK YOU _DO_ NEED THIS*/asm db 0x66
        asm pop ax
        asm db 0x66
        asm pop dx
        asm db 0x66
        asm pop bx
        // asm sti/*I THINK YOU _DO_ NEED THIS*/
        }

// ### SB8INIT ##############################################################
static int SB8Init(void)
{
        long int i;
        if((SNDfreq>22727)||(SNDfreq<3922))
        {
                Cleanup ("Illegal sound frequency");
                return 1;
                }
        oldint=_dos_getvect(SBint+8);
        _dos_setvect(SBint+8,SB8IRQHandler);
        SBWriteDSP(0xD1);
        if((SBbuf=farmalloc(SNDmixlen))==NULL)
        return 1;
        for(i=SNDmixlen-1;i>=0;i--) {
                SBbuf[i]=(SNDbuf[i]>>8)^0x80;
                }
        SB8Convert();
        if(DMASingleInit(SBdma8,SNDmixlen))
        return 1;
        SBcurdmahalf=0;
        DMASingleGo(SBcurdmahalf);
        _fmemcpy(DMAbufptr,SBbuf,SNDmixlen);
        _fmemcpy(DMAbufptr2,SBbuf,SNDmixlen);
        SBWriteDSP(0x40);
        SBWriteDSP(TimeConstant(SNDfreq));
        SB8IRQHandler();
        return 0;
        }

// ### SB8CLOSE #############################################################
static void SB8Close(void)
{
        SBResetDSP();
        farfree(SBbuf);
        outportb(0x21,inportb(0x21)|(1<<SBint));
        SBWriteDSP(0xD3);
        _dos_setvect(SBint+8,oldint);
        farfree(DMAbufptr);
        farfree(DMAbufptr2);
        }

// ### SB16IRQHANDLER #######################################################
void interrupt SB16IRQHandler(void)
{
        /*
        Dit hele asm stuk is overbodig. Push en Pop wordt
        automatisch gedaan omdat dit een interrupt handler is.
        Met dezelfde reden is ook al cli gedaan.
        [This part is unnessecary. Push and Pop are being done
        automatically because this is an interrupt handler. For
        the same reason, CLI is also already done]
        asm cli
        I THINK YOU _DO_ NEED THIS*/ asm db 0x66
        asm push bx
        asm db 0x66
        asm push dx
        asm db 0x66
        asm push ax/**/
        if(SBcurdmahalf)
        {
                SBcurdmahalf=0;
                _fmemcpy((void far *)((unsigned long)DMAbufptr+(DMAbufsize>>1)),SNDbuf, DMAbufsize>>1);
                }
        else
        {
                SBcurdmahalf=1;
                _fmemcpy(DMAbufptr,SNDbuf, DMAbufsize>>1);
                }
        SNDMix();
        inp(SBbase+0xF);
        outportb(0x20,0x20);
        /*I THINK YOU _DO_ NEED THIS*/
        asm db 0x66
        asm pop ax
        asm db 0x66
        asm pop dx
        asm db 0x66
        asm pop bx
        asm sti
        /**/
        }

// ### SB16INIT #############################################################
static int SB16Init(void)
{
        if((SNDfreq>45454)||(SNDfreq<3922))
        {
                Cleanup ("Illegal sound frequency");
                return 1;
                }
        if(DMAAutoInit(SBdma16,SNDmixlen<<2))
        return 1;
        SNDMix();
        _fmemcpy(DMAbufptr,SNDbuf, DMAbufsize>>1);
        _fmemcpy((void far *)((unsigned long)DMAbufptr+(DMAbufsize>>1)),SNDbuf, DMAbufsize>>1);
        _dos_setvect(SBint+8,SB16IRQHandler);
        SBWriteDSP(0x41);
        SBWriteDSP((int)SNDfreq>>8);
        SBWriteDSP((int)SNDfreq&255);
        SBWriteDSP(0xB6);
        SBWriteDSP(0x10);
        SBWriteDSP((SNDmixlen-1)&255);
        SBWriteDSP((SNDmixlen-1)>>8);
        //Niet nodig op SB16 [not nessecary on SB16]
        SBWriteDSP(0xD1);
        return 0;
        }

// ### SB16CLOSE ############################################################
static void SB16Close(void)
{
        SBWriteDSP(0xD5);
        outportb(0x21,inportb(0x21)|(1<<SBint));
        _dos_setvect(SBint+8,oldint);
        farfree(DMAbufptr);
        }

// ### SBINIT ###############################################################
int SBInit(int drv)
{
        if(SBGetSettings()||SBResetDSP())
        return(1);
        outportb(0x21,inportb(0x21)&~(1<<SBint));
        if(drv==1)
        {
                SBver=1;
                SB8Init();
                return 0;
                }
        if(drv==4)
        {
                SBver=4;
                SB16Init();
                return 0;
                }
        if(drv==0)
        {
                SBver=SBGetVer();
                if(SBver==1) SB8Init();
                if(SBver==4) SB16Init();
                return 0;
                }
        }

// ### SBCLOSE ##############################################################
void SBClose(void)
{
        if(SBver==1) SB8Close();
        if(SBver==4) SB16Close();
        }
