// ### INCLUDES #############################################################
#include <conio.h>
#include <stdlib.h>
#include <mem.h>
#include <alloc.h>
#include <stdio.h>
#include "cb64.h"
#include "sound.h"
#include "sbcommon.h"

// ### VARIABLES ############################################################
sndsamp far *SNDsamples[256];
sndvoice SNDvoices[3];
short far *SNDbuf;
extern unsigned char manskp;
extern unsigned char v1on=1,v2on=1,v3on=1;
long SNDfreq,SNDurate,SNDkeys,SNDvmask,SNDmixlen,leds;
static long soundon;
unsigned long C[0x10]={
        0x20000000,0x8000000,0x4000000,0x2AAAAAA,0x1AF286B,
        0x1249249,0xF0F0F0,0xCCCCCC,0xA3D70A,0x418937,0x20C49B,0x147AE1,0x10624D,
        0x57619,0x346DC,0x20C49}
;

// ### SNDSAMP ##############################################################
static sndsamp far *NewSamp(long size)
{
        sndsamp far *s;
        if(((s=farmalloc(sizeof(sndsamp)))==NULL)||
        ((s->buf=farmalloc(size*2))==NULL))
        return(NULL);
        s->length=size;
        s->loopto=-1;
        return(s);
        }

// ### KILLSAMP #############################################################
static void KillSamp(sndsamp far *s)
{
        farfree(s->buf);
        farfree(s);
        }

// ### INITWAVES ############################################################
static int InitWaves(void)
{
        int i,j;
        long t;
        float sinwav;
        short *TRI;
        short *SAW;
        short *SQR;
        short *NSE;
        if(((TRI=farmalloc(128))==NULL)||
        ((SQR=farmalloc(128))==NULL))
        return 1;
        t=-8192;
        for(i=0;i<32;i++){
                t+=512;
                TRI[i]=t;
                SQR[i]=-8192;
                }
        for(;i<64;i++){
                t-=512;
                TRI[i]=t;
                SQR[i]=8192;
                }
        t=0;
        if((SAW=farmalloc(128))==NULL)
        return 1;
        for(i=0;i<64;i++){
                t+=256;
                SAW[i]=t;
                }
        if((NSE=farmalloc(128))==NULL)
        return 1;
        for(i=0;i<64;i++) {
                NSE[i]=(rand()&0x1FFF);
                }
        for(j=0;j<256;j++) {
                if((SNDsamples[j]=NewSamp(64))==NULL)
                return 1;
                SNDsamples[j]->loopto=0;
                for(i=0;i<64;i++) {
                        t=0x0000;
                        // t=0xFFFF;
                        if(j&1){
                                t=t+TRI[i];
                                }
                        if(j&2){
                                t=t+SAW[i];
                                }
                        if(j&4){
                                t=t+SQR[i];
                                }
                        if(j&8){
                                t=t+NSE[i];
                                }
                        SNDsamples[j]->buf[i]=t;
                        }
                }
        free(TRI);
        free(SQR);
        free(NSE);
        free(SAW);
        return 0;
        }

// ### SNDDOENV #############################################################
long SNDDoEnv(long voice)
{
        unsigned long envx=SNDvoices[voice].envx;
        SNDvoices[voice].counter++;
        if (SNDvoices[voice].counter>10) {
                leds&=~(1<<voice);
                }
        switch (SNDvoices[voice].envstate)
        {
                case ATTACK:
                envx+=C[SNDvoices[voice].ar]<<1;
                if(envx>=0x7F000000)
                {
                        envx=0x7F000000;
                        if(SNDvoices[voice].sl!=0xF)
                        SNDvoices[voice].envstate=DECAY;
                        else
                        SNDvoices[voice].envstate=SUSTAIN;
                        }
                break;
                case DECAY:
                envx-=(C[SNDvoices[voice].dr]/3)<<1;
                if((envx<=0x8000000*SNDvoices[voice].sl)||(envx>0x80000000))
                {
                        envx=0x8000000*SNDvoices[voice].sl;
                        SNDvoices[voice].envstate=SUSTAIN;
                        }
                break;
                case RELEASE:
                envx-=(C[SNDvoices[voice].sr]/3)<<1;
                if((envx>0x80000000)||(envx==0))
                {
                        envx=0;
                        SNDkeys&=~(1<<voice);
                        }
                break;
                }
        return SNDvoices[voice].envx=envx;
        }

// ### AUTOSKIPPER ##########################################################
void autoskipper (void)
{
        percent=(cycles/cyc_orig);
        cycles=0;
        skipper++;
        if(percent>100)
        {
                skipper-=2;
                if(skipper<0)
                skipper=0;
                }
        else if (skipper>20) {
                skipper=20;
                }
        // skip no more than 20 frames
        // if you don't have a sb, no skipping :(
        if (percent>90&&percent<110) {
                skipper=0;
                }
        //approx.. so ok!
        if (percent<90) {
                skipper++;
                }
        if (percent>110) {
                skipper--;
                }
        if (percent>=90&&percent<100) {
                skipper++;
                }
        if (percent>100&&percent<=110) {
                skipper--;
                }
        if (skipper<0) {
                skipper=0;
                }
        if (manskp!=0) {
                skipper=manskp;
                }
        }

// ### SNDMIX ###############################################################
void SNDMix(void)
{
        long i,voice,temp,ssmp,vol;
        unsigned long pitch,ratio,sptr,len;
        short far *sbuf;
        autoskipper();
        _fmemset(SNDbuf,0,SNDmixlen<<1);
        if (v1on==0) {
                SNDkeys&=~(1<<0);
                }
        if (v2on==0) {
                SNDkeys&=~(1<<1);
                }
        if (v3on==0) {
                SNDkeys&=~(1<<2);
                }
        for(voice=0;voice<3;voice++) {
                if(SNDkeys&(1<<voice))
                {
                        vol=SNDDoEnv(voice)>>23;
                        pitch=(unsigned long)(*(unsigned short far *)&SIDRegs[voice*7])<<2;
                        ratio=(pitch<<14)/SNDfreq;
                        sbuf=SNDvoices[voice].cursamp->buf;
                        sptr=SNDvoices[voice].sampptr;
                        len=SNDvoices[voice].cursamp->length<<14;
                        for(i=0;i<SNDmixlen;i++) {
                                ssmp=sbuf[sptr>>14];
                                ssmp=(ssmp*vol)>>8;
                                temp=ssmp+SNDbuf[i];
                                if(temp>32767)
                                temp=32767;
                                else if(temp<-32767)
                                temp=-32767;
                                SNDbuf[i]=temp;
                                sptr+=ratio;
                                if(sptr>=len)
                                sptr-=len;
                                }
                        SNDvoices[voice].sampptr=sptr;
                        }
                }
        }

// ### SNDNOTEON ############################################################
void SNDNoteOn(unsigned char i)
{
        long cursamp,adsr1,adsr2;
        cursamp=(SIDRegs[(i*7)+4]>>4)&0xF;
        // if (cursamp!=1&&cursamp!=2&&cursamp!=4&&cursamp!=8) cursamp=8;
        SNDvoices[i].cursamp=SNDsamples[cursamp%16];
        SNDvoices[i].sampptr=0;
        SNDkeys|=(1<<i);
        leds|=(1<<i);
        SNDvoices[i].counter=0;
        //figure ADSR/GAIN
        adsr1=SIDRegs[(i*7)+5];
        adsr2=SIDRegs[(i*7)+6];
        SNDvoices[i].envx=0;
        SNDvoices[i].envclk=0;
        SNDvoices[i].envstate=ATTACK;
        SNDvoices[i].ar=adsr1>>4;
        SNDvoices[i].dr=adsr1&0xF;
        SNDvoices[i].sr=adsr2&0xf;
        SNDvoices[i].sl=adsr2>>4;
        }

// ### SNDNOTEOFF ###########################################################
void SNDNoteOff(unsigned char i)
{
        SNDvoices[i].envstate=RELEASE;
        SNDvoices[i].envclk=0;
        }

// ### SNDINIT ##############################################################
int SNDInit(long freq, long urate)
{
        unsigned long t;
        long i;
	//Klight(0);
        SNDfreq=freq;
        SNDurate=urate;
        SNDkeys=0;
          //Which keys are initially on (none)
        leds=0;
        SNDmixlen=SNDfreq/SNDurate;
          //How long mixing buffer is (samples)
        SNDbuf=farmalloc(SNDmixlen<<1);
        //Mixing buffer
        #ifdef PAL
        cyc_orig=9867L/SNDurate;
        #else
        cyc_orig=10227L/SNDurate;
        //How many cycles per update should be
        #endif
        C[0xF]*=(1000L/SNDurate);
        for(i=0xE;i;i--) {
                t=C[i]*(1000L/SNDurate);
                if(t<C[i+1])
                C[i]=0xFFFFFFFF;
                //overflow
                else C[i]=t;
                }
        if(InitWaves())
        return 1;
        for(i=0;i<3;i++) {
                SNDvoices[i].sampptr=-1;
                SNDvoices[i].envx=0;
                }
        return 0;
        }

// ### SNDSTART #############################################################
long SNDStart(long card)
{
        //This switch really has no point right now but if more drivers added
        // it will
        switch(card)
        {
                case 0:
                case 1:
                case 3:
                case 4: if(SBInit(card))
                return 1;
                break;
                //Any other drivers go here
                
                default:Cleanup("Illegal sound driver");
                return 1;
                }
        soundon=1;
          //Set flag: sound is initialized
        return 0;
        }

// ### SNDCLOSE #############################################################
void SNDClose(long card)
{
        int i;
        //This switch really has no point right now but if more drivers added
        // it will
        if(soundon!=1)
        return;
        switch(card)
        {
                case 0:
                case 1:
                case 3:
                case 4: SBClose();
                break;
                //Any other drivers go here
                
                default:Cleanup("Illegal sound driver");
                }
        farfree(SNDbuf);
        for(i=0;i<16;i++) {
                KillSamp(SNDsamples[i%16]);
                }
	//Klight(0);
}
