// ### DEFINES ##############################################################
#ifndef SOUND_H
#define SOUND_H
#define PAL
#define ATTACK 0	//A of ADSR
#define DECAY 1		//D of ADSR
#define SUSTAIN 2	//S of ADSR
#define RELEASE 3	//R of ADSR

// ### TYPEDEFS ##############################################################
typedef struct {
        long length;
        long loopto;
        short *buf;
        }
sndsamp;
typedef struct {
        sndsamp *cursamp;
        long sampptr;
        unsigned long envx,envclk;
        int envstate;
        int ar,dr,sl,sr;
        int counter;
        }
sndvoice;

// ### EXTERN VARIABLES #####################################################
extern sndsamp *SNDsamples[256];
extern sndvoice SNDvoices[3];
extern unsigned char v1on,v2on,v3on;
extern short *SNDbuf;
extern long SNDfreq,SNDurate,SNDkeys,SNDmixlen,leds;

// ### ROUTINE DECLARATIONS #################################################
void Klight(unsigned char);
void SNDMix(void);
void SNDNoteOn(unsigned char);
void SNDNoteOff(unsigned char);
void SNDClose(long);
long SNDDoEnv(long);
int SNDInit(long,long);
long SNDStart(long);
#endif
