/***********************************************************************
 SVI-318/328 emulator
 Copyright(c) 1998-2001 Jimmy Mrdell.  All Rights Reserved.

 MODULE:   svi.h

 ABSTRACT: This module contains generic SVI related definitions.

***********************************************************************/

#ifndef __SVI__
#define __SVI__

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned long dword;

#define ifreq 16550

void doOut(unsigned char port, unsigned char value);
unsigned char doIn(unsigned char port);
void updateCapsLock(void);
unsigned char PSGin(unsigned char PSGreg);
void setBank(unsigned char v);

void interrupt(void);
void savePSGbuf(int);
void saveSMPbuf(void);
void savePRNbuf(void);
void syncHandler(void);
void fpsHandler(void);

void mainmenu(void);
int query(void);
void clearrow(int,int);
char *selectImage(char*);
char* cutext(char*);
void autoRunProg(void);

void setEmuMode(int);

void saveImage(char*);
int loadImage(char*);

void parseArg(int,char**);
void adjustParameters(void);
void extraRAM(char*);
char *fixFileName(char*,char*);
long readHex(char*);

void resetSVI(void);
void init(void);
void trashEmu(void);

void readconfig(void);
char* trim(char*);

void printer(byte V);             /* Send a character to a printer   */

#endif
